<x-user.content>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:head> </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Produk</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid pt-5 pb-3" id="prod">
        <div class="row px-xl-5">

            @forelse ($produk as $p)
                <div class="col-lg-2 col-md-4 col-sm-6 pb-1">
                    <div class="product-item bg-light mb-4">
                        <div class="product-img position-relative overflow-hidden">
                            @if ($p->gambar != null)
                                <img class="img-fluid w-100" src="{{ asset('/storage/produk/' . $p->gambar) }}"
                                    alt="produk">
                            @else
                                <img alt="produk" class="img-fluid w-100"
                                    src="{{ asset('storage/produk/produk.jpg') }}">
                            @endif
                            <div class="product-action">

                                <a class="btn btn-outline-dark btn-square" href="detail/{{ $p->link_produk }}"><i
                                        class="fa fa-search"></i></a>
                            </div>
                        </div>
                        <div class="text-center py-4">
                            <a class="h6 text-decoration-none text-truncate" href="detail/{{ $p->link_produk }}">
                                @if (strlen($p->nm_produk) > 17)
                                    {{ substr($p->nm_produk, 0, 25) }}...
                                @else
                                    {{ $p->nm_produk }}
                                @endif
                            </a>
                            <div class="d-flex align-items-center justify-content-center mt-2">
                                @if ($p->diskon == 0)
                                    <h5>Rp. {{ number_format($p->harga_jual, 0, ',', '.') }}</h5>
                                @else
                                    <h5>Rp.
                                        {{ number_format($p->harga_jual - ($p->harga_jual * $p->diskon) / 100, 0, ',', '.') }}
                                    </h5>
                                    <h6 class="text-muted ml-2"><del>Rp.
                                            {{ number_format($p->harga_jual, 0, ',', '.') }}</del></h6>
                                @endif


                            </div>
                            @php
                                $cek = stok($p->id) - terjual($p->id);
                            @endphp
                            <button class="btn  btn-block {{ $cek == 0 ? 'btn-default disabled' : 'btn-danger beli' }}"
                                data-kd="{{ $p->kd_produk }}">
                                {!! $cek == 0 ? 'Stok Habis' : '<i class="fa fa-cart-plus"></i> Masukan keranjang' !!}
                            </button>
                        </div>
                    </div>
                </div>

            @empty
                <div class="text-center d-flex justify-item-center">
                    <h2> Produk tidak ditemukan</h2>
                </div>
            @endforelse
        </div>

        <div class="container d-flex justify-content-center">
            {{ $produk->links('components.admin.pagination') }}
        </div>
    </div>


    <div class="vh-100"></div>

    <x-slot:foot> </x-slot:foot>
</x-user.content>
